/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.wand.action;

import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import thetadev.constructionwand.api.IWandAction;
import thetadev.constructionwand.api.IWandSupplier;
import thetadev.constructionwand.basics.ConfigServer;
import thetadev.constructionwand.basics.WandUtil;
import thetadev.constructionwand.basics.option.WandOptions;
import thetadev.constructionwand.wand.undo.ISnapshot;
import thetadev.constructionwand.wand.undo.PlaceSnapshot;

public class ActionAngel
implements IWandAction {
    @Override
    public int getLimit(ItemStack wand) {
        return ConfigServer.getWandProperties(wand.m_41720_()).getAngel();
    }

    @Override
    @Nonnull
    public List<ISnapshot> getSnapshots(Level world, Player player, BlockHitResult rayTraceResult, ItemStack wand, WandOptions options, IWandSupplier supplier, int limit) {
        LinkedList<ISnapshot> placeSnapshots = new LinkedList<ISnapshot>();
        Direction placeDirection = rayTraceResult.m_82434_();
        BlockPos currentPos = rayTraceResult.m_82425_();
        BlockState supportingBlock = world.m_8055_(currentPos);
        for (int i = 0; i < limit; ++i) {
            PlaceSnapshot snapshot = supplier.getPlaceSnapshot(world, currentPos = currentPos.m_141952_(placeDirection.m_122424_().m_122436_()), rayTraceResult, supportingBlock);
            if (snapshot == null) continue;
            placeSnapshots.add(snapshot);
            break;
        }
        return placeSnapshots;
    }

    @Override
    @Nonnull
    public List<ISnapshot> getSnapshotsFromAir(Level world, Player player, BlockHitResult rayTraceResult, ItemStack wand, WandOptions options, IWandSupplier supplier, int limit) {
        Vec3 lookVec;
        LinkedList<ISnapshot> placeSnapshots = new LinkedList<ISnapshot>();
        if (!player.m_7500_() && !((Boolean)ConfigServer.ANGEL_FALLING.get()).booleanValue() && player.f_19789_ > 10.0f) {
            return placeSnapshots;
        }
        Vec3 playerVec = WandUtil.entityPositionVec((Entity)player);
        Vec3 placeVec = playerVec.m_82549_(lookVec = player.m_20154_().m_82542_(2.0, 2.0, 2.0));
        BlockPos currentPos = new BlockPos(placeVec);
        PlaceSnapshot snapshot = supplier.getPlaceSnapshot(world, currentPos, rayTraceResult, null);
        if (snapshot != null) {
            placeSnapshots.add(snapshot);
        }
        return placeSnapshots;
    }
}

